#include <GUIConstantsEx.au3>
#include 'GroupCheckBox.au3'

Global $aCB_Data[][2] = _
	[ _
		['CheckBox1', 'Some data for CheckBox1'], _
		['CheckBox2', 'Some data for CheckBox2'], _
		['CheckBox3', 'Some data for CheckBox3'], _
		['CheckBox4', 'Some data for CheckBox4'], _
		['CheckBox5', 'Some data for CheckBox5'] _
	]

$hGUI = GUICreate('GroupCheckBox Example 1', 410, 200)

$hGroupCheckBox = _GroupCheckBox_Create($aCB_Data, 20, 20, -1, -1, 2, 30, 10)
$iCheckAll_CB = GUICtrlCreateCheckbox('Check All', 20, 80)
$iRemove_Bttn = GUICtrlCreateButton('Remove (1 | 3 | 5)', 20, 130, 100, 20)
$iStatus_Lbl = GUICtrlCreateLabel('', 20, 170, 270, 20)

GUICtrlSetFont(-1, 9, 600)
GUICtrlSetColor(-1, 0x0000FF)

Global $aCB_Data[][2] = _
	[ _
		['CheckBox6', 'Some data for CheckBox6'], _
		['CheckBox7', 'Some data for CheckBox7'], _
		['CheckBox8', 'Some data for CheckBox8'] _
	]

_GroupCheckBox_Add($hGroupCheckBox, $aCB_Data, -1)

GUISetState(@SW_SHOW, $hGUI)

While 1
	$iMsg = GUIGetMsg()
	
	Switch $iMsg
		Case $GUI_EVENT_CLOSE
			_GroupCheckBox_Destroy($hGroupCheckBox)
			Exit
		Case $iRemove_Bttn
			_GroupCheckBox_Remove($hGroupCheckBox, '1|3|5', True)
			GUICtrlSetState($iRemove_Bttn, $GUI_DISABLE)
		Case $iCheckAll_CB
			$iState = $GCB_CHECK_STATE_NONE
			
			If GUICtrlRead($iCheckAll_CB) = $GUI_CHECKED Then
				$iState = $GCB_CHECK_STATE_ALL
			EndIf
			
			_GroupCheckBox_SetState($hGroupCheckBox, $iState, -1)
			
			ContinueCase
		Case _GroupCheckBox_GetEvent($hGroupCheckBox, $iMsg)
			GUICtrlSetData($iStatus_Lbl, '')
			
			$iState = _GroupCheckBox_GetState($hGroupCheckBox)
			
			Switch $iState
				Case $GCB_CHECK_STATE_ONE
					GUICtrlSetData($iStatus_Lbl, 'One (Or More) CheckBoxes Checked')
				Case $GCB_CHECK_STATE_ALL
					GUICtrlSetState($iCheckAll_CB, $GUI_CHECKED)
					GUICtrlSetData($iStatus_Lbl, 'All CheckBoxes Checked.')
					
					$iCB = Random(1, _GroupCheckBox_GetInfo($hGroupCheckBox), 1)
					$aInfo = _GroupCheckBox_GetInfo($hGroupCheckBox, $iCB, $GCB_INDEX_ALL)
					
					If Not @error Then
						MsgBox(64, 'State', _
							StringFormat('All CheckBoxes Checked.\n\nCheckBox #%i (Random) Info:\n\nCtrlID = %i\nText = %s\nParam = %s', _
								$iCB, $aInfo[$GCB_INDEX_CTRLID], $aInfo[$GCB_INDEX_TEXT], $aInfo[$GCB_INDEX_PARAM]), _
							0, $hGUI)
					EndIf
				Case $GCB_CHECK_STATE_NONE
					GUICtrlSetState($iCheckAll_CB, $GUI_UNCHECKED)
					GUICtrlSetData($iStatus_Lbl, 'All CheckBoxes UnChecked.')
			EndSwitch
	EndSwitch
WEnd